package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.common.exception.CheckedException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;

import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDocumentRuleEvaluatorFactory extends BusinessIntegrationTest {
	
	@Test
	public void testOne() throws Exception {
		try {
			DocumentRuleEvaluatorFactory.getEvaluator(null);
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}
		
		try {
			DocumentRuleEvaluatorFactory.getEvaluator("");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			DocumentRuleEvaluatorFactory.getEvaluator("foobie-bletch");
			Assert.fail("Expected CheckedException");
		} catch (CheckedException e) {}

		try {
			// must use the fqpn of the evaluator class
			DocumentRuleEvaluatorFactory.getEvaluator("BIRLSDocumentRuleEvaluator");
			Assert.fail("Expected CheckedException");
		} catch (CheckedException e) {}

		Object obj = DocumentRuleEvaluatorFactory.getEvaluator("gov.va.vinci.dart.rule.BIRLSDocumentRuleEvaluator");
		Assert.assertNotNull(obj);
		Assert.assertTrue(obj instanceof BIRLSDocumentRuleEvaluator);
	}

}
